﻿using System;
using System.Collections.Generic;
using VeteransAffairs.Registries.Business;

public partial class controls_TbiDiagnosisSelector : System.Web.UI.UserControl
{

    #region Public Member Variables

    public string SurveyTypeCode { get; set; }
    public string QuestionNumber { get; set; }
    public string QuestionText { get; set; }
    public string SelectedChoiceId { get; set; }

    public short StartTabIndex
    {
        set
        {
            LabelForQDX.TabIndex = value;
            //rblDiagnosisList.TabIndex = (short)(value + 1);
            //RequiredFieldValidatorDXList.TabIndex = (short)(value + 2);
            //LabelOtherDescription.TabIndex = (short)(value + 3);
            //txtOther.TabIndex = (short)(value + 4);
            //RequiredFieldValidatorOther.TabIndex = (short)(value + 5);
        }
        get
        {
            return LabelForQDX.TabIndex;
        }
    }

    #endregion

    #region Public Methods

    /// <summary>
    /// returns the selected value of the choice - choice id ... cast to int before save.
    /// </summary>
    /// <returns></returns>
    public string GetSelectedId()
    {
        return rblDiagnosisList.SelectedValue;
    }

    /// <summary>
    /// returns the value to be stored in the survey_result - result_text field.
    /// </summary>
    /// <returns></returns>
    public string GetSelectedResultText()
    {
        if (rblDiagnosisList.SelectedItem == null)
            return "";
        if (rblDiagnosisList.SelectedItem.Text.ToLower() == "other")
        {
            // if other ... return what is in text box
            return txtOther.Text;
        }
        else
        {
            return rblDiagnosisList.SelectedItem.Text;
        }
    }

    /// <summary>
    /// Set other desc text.
    /// </summary>
    /// <param name="value"></param>
    public void SetOtherDescriptionText(string value)
    {
        pnlOtherDescription.Enabled = txtOther.Enabled = RequiredFieldValidatorOther.Enabled = true;
        txtOther.Text = value;
    }

    #endregion

    /// <summary>
    /// Path_Load method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        LabelForQDX.Text = QuestionText;
        HiddenQDX.Value = QuestionNumber;
        HiddenSurveyTypeDX.Value = SurveyTypeCode;

        if (IsPostBack)
        {
            if (rblDiagnosisList.SelectedIndex > -1)
            {
                if (rblDiagnosisList.SelectedItem.Text.ToLower().Contains("other"))
                {
                    pnlOtherDescription.Enabled = txtOther.Enabled = RequiredFieldValidatorOther.Enabled = true;
                }
                else
                {
                    pnlOtherDescription.Enabled = txtOther.Enabled = RequiredFieldValidatorOther.Enabled = false;
                }
            }
            else
            {
                pnlOtherDescription.Enabled = txtOther.Enabled = RequiredFieldValidatorOther.Enabled = false;
            }
        }
    }

    /// <summary>
    /// Databound
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void rblDiagnosisList_DataBound(object sender, EventArgs e)
    {
        if (!String.IsNullOrEmpty(SelectedChoiceId))
        {
            rblDiagnosisList.SelectedValue = SelectedChoiceId;
        }
    }

    #region Caching

    private string IDFieldName { get { return this.ID + "_ID"; } }
    private string OtherFieldName { get { return this.ID + "_Other"; } }

    public void ReadFromCache(Dictionary<string, string> cache)
    {
        string value;
        if (cache.TryGetValue(IDFieldName, out value) && value != null)
        {
            this.SelectedChoiceId = value;
        }
        if (cache.TryGetValue(OtherFieldName, out value) && value != null)
        {
            this.SetOtherDescriptionText(value);
        }
    }

    public void WriteToCache(Dictionary<string, string> cache)
    {
        cache[IDFieldName] = GetSelectedId();

        if (!String.IsNullOrEmpty(GetSelectedId()) && rblDiagnosisList.SelectedItem.Text.ToLower() == "other")
            cache[OtherFieldName] = txtOther.Text;
    }

    #endregion Caching
}